/****** OBJECT:  USERDEFINEDFUNCTION [DBO].[UFD_PDV_VD_MARGEM_LUCRATIVIDADE]    SCRIPT DATE: 03/25/2013 09:43:56 ******/
IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[UFD_PDV_VD_MARGEM_LUCRATIVIDADE]') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [DBO].[UFD_PDV_VD_MARGEM_LUCRATIVIDADE]
GO

CREATE FUNCTION UFD_PDV_VD_MARGEM_LUCRATIVIDADE(@CD_EMP INT, 
												@CD_FILIAL INT,
												@VLR_PROD_VENDA_LIQUIDA MONEY,
												@VLR_PROD_CUSTO MONEY,
												@PERC_LUCRATIVIDADE_REDE MONEY)
RETURNS @RSLUCRATIVIDADE TABLE (    
           PERC_MARGEM MONEY,
		   PERC_LUCRATIVIDADE_META   MONEY,    
           PERC_ATINGIDO MONEY,    
           COR  INT,
		   DS_COR VARCHAR(100))  
AS
BEGIN
DECLARE @DT_ATUAL DATETIME
DECLARE @MES_ATUAL INT
DECLARE @ANO_ATUAL INT
DECLARE @PERC_LUCRATIVIDADE MONEY

DECLARE @PRETO MONEY
DECLARE @VERMELHO MONEY
DECLARE @AMARELHO MONEY
DECLARE @VERDE MONEY
DECLARE @AZUL MONEY
DECLARE @PERC_ATINGIDO MONEY
DECLARE @PERC_MARGEM MONEY

SELECT
	@PRETO=PERC_MAX
FROM
	EST_SEMAFARO_META
WHERE
	CD_SEQ=1

SELECT
	@VERMELHO=PERC_MAX
FROM
	EST_SEMAFARO_META
WHERE
	CD_SEQ=2

SELECT
	@AMARELHO=PERC_MAX
FROM
	EST_SEMAFARO_META
WHERE
	CD_SEQ=3

SELECT
	@VERDE=PERC_MAX
FROM
	EST_SEMAFARO_META
WHERE
	CD_SEQ=4


SET 
@DT_ATUAL=GETDATE()

SET 
@MES_ATUAL=MONTH(@DT_ATUAL)

SET 
@ANO_ATUAL=YEAR(@DT_ATUAL)

SET @PERC_LUCRATIVIDADE=@PERC_LUCRATIVIDADE_REDE

IF @PERC_LUCRATIVIDADE_REDE=0
begin
SELECT
	@PERC_LUCRATIVIDADE=PERC_LUCRATIVIDADE
FROM
	EST_META_FILIAL
WHERE
	MES_META = @MES_ATUAL
	AND ANO_META = @ANO_ATUAL
	AND CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND PERC_LUCRATIVIDADE>0
end


SET @PERC_MARGEM=100
IF @VLR_PROD_CUSTO>0 
BEGIN
	SET @PERC_MARGEM= ((@VLR_PROD_VENDA_LIQUIDA-@VLR_PROD_CUSTO)/@VLR_PROD_VENDA_LIQUIDA)*100
END

SET @PERC_ATINGIDO=(@PERC_MARGEM/@PERC_LUCRATIVIDADE)*100

INSERT INTO @RSLUCRATIVIDADE
SELECT 
	@PERC_MARGEM,
	@PERC_LUCRATIVIDADE,
	@PERC_ATINGIDO,
	CASE WHEN @PERC_ATINGIDO>0 THEN
		CASE WHEN @PERC_ATINGIDO BETWEEN 0 AND @PRETO THEN
			1
		WHEN @PERC_ATINGIDO BETWEEN @PRETO AND @VERMELHO THEN
			2
		WHEN @PERC_ATINGIDO BETWEEN @VERMELHO AND @AMARELHO THEN
			3
		WHEN @PERC_ATINGIDO BETWEEN @AMARELHO AND @VERDE THEN
			4
		ELSE
			5
		END
	ELSE
		1
	END,
	CASE WHEN @PERC_ATINGIDO>0THEN
		CASE WHEN @PERC_ATINGIDO BETWEEN 0 AND @PRETO THEN
			'PRETO'
		WHEN @PERC_ATINGIDO BETWEEN @PRETO AND @VERMELHO THEN
			'VERMELHO'
		WHEN @PERC_ATINGIDO BETWEEN @VERMELHO AND @AMARELHO THEN
			'AMARELHO'
		WHEN @PERC_ATINGIDO BETWEEN @AMARELHO AND @VERDE THEN
			'VERDE'
		ELSE
			'AZUL'
		END
	ELSE
		'PRETO'
	END
RETURN
END